class BukkakeTracer extends Projectile;

simulated function PostBeginPlay()
{
	//log("Spawn"@self@"with role"@Role@"and netmode"@Level.netmode);
	Super.PostBeginPlay();
	Velocity = Speed * vector(Rotation);
	if ( Level.bDropDetail )
		LightType = LT_None;
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	Destroy();
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
	If ( Other!=Instigator )
		Destroy();
}

defaultproperties
{
     speed=4000.000000
     MaxSpeed=4500.000000
     Damage=0.000000
     MomentumTransfer=60000
     MyDamageType=Corroded
     ImpactSound=Sound'Botpack.BioRifle.GelHit'
     MiscSound=Sound'Botpack.BioRifle.GelHit'
     bNetTemporary=False
     Physics=PHYS_Projectile
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=6.000000
     AnimSequence=Flying
     Style=STY_Translucent
     MultiSkins(0)=Texture'Goo'
     MultiSkins(1)=Texture'Goo'
     Texture=Texture'Goo'
     Mesh=Mesh'Botpack.BioGelm'
     DrawScale=1.000000
     AmbientGlow=255
     bUnlit=True
     bMeshEnviroMap=True
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bProjTarget=True
     LightType=LT_Steady
     LightEffect=LE_WateryShimmer
     LightBrightness=64
     LightHue=0
     LightSaturation=255
     LightRadius=6
     bBounce=False
     Buoyancy=170.000000
}
